REMARKS TOPH19.PRO ( protein topology )
REMARKS ===============================
REMARKS Charges and atom order modified for neutral GROUPs.
REMARKS Histidine charges set to Del Bene and Cohen sto-3g calculations.
REMARKS Amide charges set to match the experimental dipole moment.
REMARKS Default for HIStidines is the doubly protonated state 

REMARKS this is not the original file
REMARKS some residues and patches added by MN, Institut Pasteur

set echo=false end
!! for use with PARAM19 parameters ( no special hydrogen bonding potential )
!! donor and acceptor terms just for analysis

AUTOGENERATE  ANGLES=TRUE  END
{*===========================*}

{* protein default masses *}
MASS   H      1.00800! hydrogen which can h-bond to neutral atom
MASS   HC     1.00800!    ="=     ="=     ="=    to charged atom
MASS   HA     1.00800! aliphatic hydrogen
MASS   CT    12.01100! aliphatic carbon
MASS   C     12.01100! carbonyl carbon
MASS   CH1E  13.01900! extended atom carbon with one hydrogen
MASS   CH2E  14.02700!    ="=      ="=     ="=   two hydrogens
MASS   CH3E  15.03500!    ="=      ="=     ="=   three hydrogens
MASS   CR1E  13.01900!    ="=      ="=      in an aromatic ring with one H
MASS   N     14.00670! peptide nitrogen with no hydrogens attached
MASS   NR    14.00670! nitrogen in an aromatic ring with no hydrogens
MASS   NP    14.00670! pyrole nitrogen
MASS   NH1   14.00670! peptide nitrogen bound to one hydrogen
MASS   NH2   14.00670!    ="=       ="=      ="= two hydrogens
MASS   NH3   14.00670! nitrogen bound to three hydrogens
MASS   NC2   14.00670! charged guandinium nitrogen bound to two hydrogens
MASS   O     15.99940! carbonyl oxygen
MASS   OC    15.99940! carboxy oxygen
MASS   OH1   15.99940! hydroxy oxygen
MASS   OS    15.99940! oxygen
MASS   O2    15.99940! oxygen
MASS   S     32.06000! sulphur
MASS   SH1E  33.06800! extended atom sulfur with one hydrogen
MASS   P     30.97000! phosphorous
MASS   CAL   40.0800 ! calcium 2+

!some empirical rules for the following topologies:
!
! 1. angles are taken between all permutations of atoms bonded to
!    a particular atom. Exception: 2 angles linking the THR double ring
! 2. each bond with non-terminal atoms creates one dihedral. Exception:
!    ring bonds in aromatic side chains (but not PRO).
! 3. each planar atom vertex creates one improper-planar term
!    execption: ARG head groups.
! 4. each 1-extended-H carbon atom creates one improper-tetrahedral term
!    (for chirality)
! 5. Each bond in an aromatic ring creates one improper-torsion term
!    (exception: PRO)
! 6. LYS head groups and methyl head groups create one dihedral for 
!    each hydrogen
! 7. all 1:2 and 1:3 nonbonded interactions are assumed to be excluded
! 8. All 1:4,1:5,... non-bonded interactions in aromatic rings 
!    (or double rings) are explicitly excluded
!

! ---------------------------------------------------------------------

RESIdue ALA
 GROUp
  ATOM N    TYPE=NH1   CHARge=-0.35   END
  ATOM H    TYPE=H     CHARge= 0.25   END
  ATOM CA   TYPE=CH1E  CHARge= 0.10   END
 GROUp
  ATOM CB   TYPE=CH3E  CHARge= 0.00   END
 GROUp
  ATOM C    TYPE=C     CHARge= 0.55   END  !#
  ATOM O    TYPE=O     CHARge=-0.55   END  !#

 BOND N    CA
 BOND CA   C
 BOND C    O
 BOND N    H
 BOND CA   CB

 IMPRoper  CA     N    C  CB  !tetrahedral CA

 DONOr H    N
 ACCEptor O C


END {ALA}

!------------------------------------------------------------------

RESIdue ARG
 GROUp
  ATOM N     TYPE=NH1   CHARge=-0.35   END
  ATOM H     TYPE=H     CHARge= 0.25   END
  ATOM CA    TYPE=CH1E  CHARge= 0.10   END
 GROUp 
  ATOM CB    TYPE=CH2E  CHARge= 0.00   END
  ATOM CG    TYPE=CH2E  CHARge= 0.00   END
 GROUp
  ATOM CD    TYPE=CH2E  CHARge= 0.10   END  !#
  ATOM NE    TYPE=NH1   CHARge=-0.40   END  !#
  ATOM HE    TYPE=H     CHARge= 0.30   END  !#
  ATOM CZ    TYPE=C     CHARge= 0.50   END  !#
 GROUp
  ATOM NH1   TYPE=NC2   CHARge= -0.45  END  !#
  ATOM HH11  TYPE=HC    CHARge=  0.35  END  !#
  ATOM HH12  TYPE=HC    CHARge=  0.35  END  !#
 GROUp
  ATOM NH2   TYPE=NC2   CHARge= -0.45  END  !#
  ATOM HH21  TYPE=HC    CHARge=  0.35  END  !#
  ATOM HH22  TYPE=HC    CHARge=  0.35  END  !#
 GROUp
  ATOM C     TYPE=C     CHARge=  0.55  END  !#
  ATOM O     TYPE=O     CHARge= -0.55  END  !#

 BOND N    CA
 BOND CA   C
 BOND C    O
 BOND N    H
 BOND CA   CB
 BOND CB   CG
 BOND CG   CD
 BOND CD   NE
 BOND NE   HE
 BOND NE   CZ
 BOND CZ   NH1
 BOND CZ   NH2
 BOND NH1  HH11
 BOND NH1  HH12
 BOND NH2  HH21
 BOND NH2  HH22

 DIHEdral N    CA   CB   CG
 DIHEdral CA   CB   CG   CD
 DIHEdral CB   CG   CD   NE
 DIHEdral CG   CD   NE   CZ
 DIHEdral CD   NE   CZ   NH1
 DIHEdral NE   CZ   NH1  HH11 !note: one dehidral for each hydrogen
 DIHEdral NE   CZ   NH2  HH21 !
 DIHEdral NE   CZ   NH1  HH12 !
 DIHEdral NE   CZ   NH2  HH22 !

 IMPRoper CA   N    C    CB !tetrahedral CA
 IMPRoper NE   CD   CZ   HE !planar NE
 IMPRoper CZ   NH1  NH2  NE !planar CZ

 DONOr H    N
 DONOr HE   NE
 DONOr HH11 NH1
 DONOr HH12 NH1
 DONOr HH21 NH2
 DONOr HH22 NH2
 ACCEptor O C


END {ARG}

!------------------------------------------------------------------

RESIdue ASN
 GROUp
  ATOM N    TYPE=NH1   CHARge=-0.35   END
  ATOM H    TYPE=H     CHARge= 0.25   END
  ATOM CA   TYPE=CH1E  CHARge= 0.10   END
 GROUp
  ATOM CB   TYPE=CH2E  CHARge= 0.00   END
 GROUp
  ATOM CG   TYPE=C     CHARge= 0.55   END  !#
  ATOM OD1  TYPE=O     CHARge=-0.55   END  !#
 GROUp
  ATOM ND2  TYPE=NH2   CHARge=-0.60   END  !#
  ATOM HD21 TYPE=H     CHARge= 0.30   END  !#
  ATOM HD22 TYPE=H     CHARge= 0.30   END  !#
 GROUp
  ATOM C    TYPE=C     CHARge= 0.55   END  !#
  ATOM O    TYPE=O     CHARge=-0.55   END  !#

 BOND N    CA
 BOND CA   C
 BOND C    O
 BOND N    H
 BOND CA   CB
 BOND CB   CG
 BOND CG   OD1
 BOND CG   ND2
 BOND ND2  HD21
 BOND ND2  HD22

 DIHEdral N    CA   CB   CG
 DIHEdral CA   CB   CG   OD1
 DIHEdral CB   CG   ND2  HD21

 IMPRoper CA   N    C    CB  !tetrahedral CA
 IMPRoper CG   OD1  ND2  CB  !planar CG
 IMPRoper ND2  HD21 HD22 CG  !planar ND2

 DONOr H    N  
 DONOr HD21 ND2
 DONOr HD22 ND2
 ACCEptor OD1 CG
 ACCEptor O C


END {ASN}

!------------------------------------------------------------------

RESIdue ASP
 GROUp
  ATOM N    TYPE=NH1   CHARge=-0.35   END
  ATOM H    TYPE=H     CHARge= 0.25   END
  ATOM CA   TYPE=CH1E  CHARge= 0.10   END
 GROUp 
  ATOM CB   TYPE=CH2E  CHARge=-0.16   END
  ATOM CG   TYPE=C     CHARge= 0.36   END
  ATOM OD1  TYPE=OC    CHARge=-0.60   END
  ATOM OD2  TYPE=OC    CHARge=-0.60   END
 GROUp
  ATOM C    TYPE=C     CHARge= 0.55   END  !#
  ATOM O    TYPE=O     CHARge=-0.55   END  !#

 BOND N    CA
 BOND CA   C
 BOND C    O
 BOND N    H
 BOND CA   CB
 BOND CB   CG
 BOND CG   OD1
 BOND CG   OD2

 DIHEdral N    CA   CB   CG
 DIHEdral CA   CB   CG   OD1

 IMPRoper CA   N    C    CB  !tetrahedral CA
 IMPRoper CG   OD1  OD2  CB  !planar CG

 DONOr H    N
 ACCEptor OD1 CG
 ACCEptor OD2 CG
 ACCEptor O C


END {ASP}

!------------------------------------------------------------------

RESIdue CYS
 GROUp
  ATOM N    TYPE=NH1   CHARge=-0.35   END
  ATOM H    TYPE=H     CHARge= 0.25   END
  ATOM CA   TYPE=CH1E  CHARge= 0.10   END
 GROUp
  ATOM CB   TYPE=CH2E  CHARge= 0.19   END
  ATOM SG   TYPE=SH1E  CHARge=-0.19   END
 GROUp
  ATOM C    TYPE=C     CHARge= 0.55   END  !#
  ATOM O    TYPE=O     CHARge=-0.55   END  !#

 BOND N    CA
 BOND CA   C
 BOND C    O
 BOND N    H
 BOND CA   CB
 BOND CB   SG

 DIHEdral N    CA   CB   SG

 IMPRoper CA   N    C    CB   !tetrahedral CA

 DONOr H    N
 ACCEptor O C


END {CYS}

!------------------------------------------------------------------

RESIdue GLN
 GROUp
  ATOM N    TYPE=NH1   CHARge=-0.35   END
  ATOM H    TYPE=H     CHARge= 0.25   END
  ATOM CA   TYPE=CH1E  CHARge= 0.10   END
 GROUp
  ATOM CB   TYPE=CH2E  CHARge= 0.00   END
  ATOM CG   TYPE=CH2E  CHARge= 0.00   END
 GROUp 
  ATOM CD   TYPE=C     CHARge= 0.55   END !#
  ATOM OE1  TYPE=O     CHARge=-0.55   END !#
 GROUp
  ATOM NE2  TYPE=NH2   CHARge=-0.60   END
  ATOM HE21 TYPE=H     CHARge= 0.30   END
  ATOM HE22 TYPE=H     CHARge= 0.30   END
 GROUp
  ATOM C    TYPE=C     CHARge= 0.55   END
  ATOM O    TYPE=O     CHARge=-0.55   END

 BOND N    CA
 BOND CA   C
 BOND C    O
 BOND N    H
 BOND CA   CB
 BOND CB   CG
 BOND CG   CD
 BOND CD   OE1
 BOND CD   NE2
 BOND NE2  HE21
 BOND NE2  HE22

 DIHEdral N    CA   CB   CG
 DIHEdral CA   CB   CG   CD 
 DIHEdral CB   CG   CD   OE1
 DIHEdral CG   CD   NE2  HE21

 IMPRoper CA   N    C    CB   !tetrahedral CA
 IMPRoper CD   OE1  NE2  CG   !planar CD
 IMPRoper NE2  HE21 HE22 CD   !planar NE2

 DONOr H    N
 DONOr HE21 NE2
 DONOr HE22 NE2
 ACCEptor OE1 CD
 ACCEptor O C


END {GLN}

!------------------------------------------------------------------

RESIdue GLU
 GROUp
  ATOM N    TYPE=NH1   CHARge=-0.35   END
  ATOM H    TYPE=H     CHARge= 0.25   END
  ATOM CA   TYPE=CH1E  CHARge= 0.10   END
 GROUp
  ATOM CB   TYPE=CH2E  CHARge= 0.00   END
 GROUp
  ATOM CG   TYPE=CH2E  CHARge=-0.16   END
  ATOM CD   TYPE=C     CHARge= 0.36   END
  ATOM OE1  TYPE=OC    CHARge=-0.60   END
  ATOM OE2  TYPE=OC    CHARge=-0.60   END
 GROUp
  ATOM C    TYPE=C     CHARge= 0.55   END   !#
  ATOM O    TYPE=O     CHARge=-0.55   END   !#

 BOND N    CA
 BOND CA   C
 BOND C    O
 BOND N    H
 BOND CA   CB
 BOND CB   CG
 BOND CG   CD
 BOND CD   OE1
 BOND CD   OE2

 DIHEdral N    CA   CB   CG
 DIHEdral CA   CB   CG   CD
 DIHEdral CB   CG   CD   OE1  !note: only one dihedral for CG-CD

 IMPRoper CA   N    C    CB  !tetrahedral CA
 IMPRoper CD   OE1  OE2  CG  !planar CD

 DONOr H    N
 ACCEptor OE1 CD
 ACCEptor OE2 CD
 ACCEptor O C


END {GLU}

!------------------------------------------------------------------

RESIdue GLY
 GROUp
  ATOM N    TYPE=NH1   CHARge=-0.35   END
  ATOM H    TYPE=H     CHARge= 0.25   END
  ATOM CA   TYPE=CH2E  CHARge= 0.10   END
 GROUp
  ATOM C    TYPE=C     CHARge= 0.55   END  !#
  ATOM O    TYPE=O     CHARge=-0.55   END  !#

 BOND N    CA
 BOND CA   C
 BOND C    O
 BOND N    H

 DONOr H    N
 ACCEptor O C

END {GLY}

!------------------------------------------------------------------


RESIdue HIS    { Doubly protonated histidine.  Ring charges
                 Hayes and Kollman jacs 98:3335 (1976)      }
 GROUp
  ATOM N    TYPE=NH1   CHARge=-0.35   END
  ATOM H    TYPE=H     CHARge= 0.25   END
  ATOM CA   TYPE=CH1E  CHARge= 0.10   END
 GROUp
  ATOM CB   TYPE=CH2E  CHARge= 0.10   END
  ATOM CG   TYPE=C     CHARge= 0.15   END
  ATOM CD2  TYPE=CR1E  CHARge= 0.20   END
 GROUp
  ATOM ND1  TYPE=NH1   CHARge=-0.30   END  !#
  ATOM HD1  TYPE=H     CHARge= 0.35   END  !#
 GROUp
  ATOM CE1  TYPE=CR1E  CHARge= 0.45   END  !#
 GROUp
  ATOM NE2  TYPE=NH1   CHARge=-0.30   END  !#
  ATOM HE2  TYPE=H     CHARge= 0.35   END  !#
 GROUp
  ATOM C    TYPE=C     CHARge= 0.55   END  !#
  ATOM O    TYPE=O     CHARge=-0.55   END  !#

 BOND N    CA
 BOND CA   C
 BOND C    O
 BOND N    H
 BOND CA   CB
 BOND CB   CG
 BOND CG   ND1
 BOND CG   CD2
 BOND ND1  HD1
 BOND ND1  CE1
 BOND CD2  NE2
 BOND CE1  NE2
 BOND NE2  HE2

 DIHEdral N    CA   CB   CG 
 DIHEdral CA   CB   CG   ND1

 IMPRoper CA   N    C    CB  !tetrahedral CA
 IMPRoper CG   ND1  CD2  CB  !planar CG
 IMPRoper ND1  CG   CE1  HD1 !planar ND1
 IMPRoper NE2  CD2  CE1  HE2 !planar NE2

 IMPRoper CG   ND1  CE1  NE2 !!
 IMPRoper ND1  CE1  NE2  CD2 !!
 IMPRoper CE1  NE2  CD2  CG  !! ring torsions
 IMPRoper NE2  CD2  CG   ND1 !!
 IMPRoper CD2  CG   ND1  CE1 !!

 DONOr H    N 
 DONOr HD1  ND1
 DONOr HE2  NE2
 ACCEptor O C


END {HIS}

!------------------------------------------------------------------


RESIdue ILE
 GROUp
  ATOM N    TYPE=NH1   CHARge=-0.35   END
  ATOM H    TYPE=H     CHARge= 0.25   END
  ATOM CA   TYPE=CH1E  CHARge= 0.10   END
 GROUp
  ATOM CB   TYPE=CH1E  CHARge= 0.00   END
  ATOM CG2  TYPE=CH3E  CHARge= 0.00   END
 GROUp 
  ATOM CG1  TYPE=CH2E  CHARge= 0.00   END
  ATOM CD   TYPE=CH3E  CHARge= 0.00   END
 GROUp
  ATOM C    TYPE=C     CHARge= 0.55   END  !#
  ATOM O    TYPE=O     CHARge=-0.55   END  !#

 BOND N    CA
 BOND CA   C
 BOND C    O
 BOND N    H
 BOND CA   CB
 BOND CB   CG1
 BOND CB   CG2
 BOND CG1  CD

 DIHEdral N    CA   CB   CG1  !note: only one dihedral around CA-CB
 DIHEdral CA   CB   CG1  CD

 IMPRoper CA   N    C    CB  !tetrahedral CA
 IMPRoper CB   CG1  CG2  CA  !planar CB

 DONOr H    N
 ACCEptor O C


END {ILE}

!------------------------------------------------------------------

RESIdue LEU
 GROUp
  ATOM N    TYPE=NH1   CHARge=-0.35   END
  ATOM H    TYPE=H     CHARge= 0.25   END
  ATOM CA   TYPE=CH1E  CHARge= 0.10   END
 GROUp
  ATOM CB   TYPE=CH2E  CHARge= 0.00   END
  ATOM CG   TYPE=CH1E  CHARge= 0.00   END
  ATOM CD1  TYPE=CH3E  CHARge= 0.00   END
  ATOM CD2  TYPE=CH3E  CHARge= 0.00   END
 GROUp
  ATOM C    TYPE=C     CHARge= 0.55   END  !#
  ATOM O    TYPE=O     CHARge=-0.55   END  !#

 BOND N    CA
 BOND CA   C
 BOND C    O
 BOND N    H
 BOND CA   CB
 BOND CB   CG
 BOND CG   CD1
 BOND CG   CD2

 DIHEdral N    CA   CB   CG
 DIHEdral CA   CB   CG   CD2  !note: only one dihedral around CB-CG

 IMPRoper CA   N    C    CB  !tetrahedral CA
 IMPRoper CG   CD2  CD1  CB  !planar CG

 DONOr H    N
 ACCEptor O C


END {LEU}

!------------------------------------------------------------------

RESIdue LYS
 GROUp
  ATOM N    TYPE=NH1   CHARge=-0.35   END
  ATOM H    TYPE=H     CHARge= 0.25   END
  ATOM CA   TYPE=CH1E  CHARge= 0.10   END
 GROUp
  ATOM CB   TYPE=CH2E  CHARge= 0.00   END
  ATOM CG   TYPE=CH2E  CHARge= 0.00   END
  ATOM CD   TYPE=CH2E  CHARge= 0.00   END
 GROUp
  ATOM CE   TYPE=CH2E  CHARge= 0.25   END  !#
  ATOM NZ   TYPE=NH3   CHARge=-0.30   END  !#
  ATOM HZ1  TYPE=HC    CHARge= 0.35   END  !#
  ATOM HZ2  TYPE=HC    CHARge= 0.35   END  !#
  ATOM HZ3  TYPE=HC    CHARge= 0.35   END  !#
 GROUp
  ATOM C    TYPE=C     CHARge= 0.55   END  !#
  ATOM O    TYPE=O     CHARge=-0.55   END  !#

 BOND N    CA
 BOND CA   C
 BOND C    O
 BOND N    H
 BOND CA   CB
 BOND CB   CG
 BOND CG   CD
 BOND CD   CE
 BOND CE   NZ
 BOND NZ   HZ1
 BOND NZ   HZ2
 BOND NZ   HZ3

 DIHEdral N    CA   CB   CG
 DIHEdral CA   CB   CG   CD
 DIHEdral CB   CG   CD   CE
 DIHEdral CG   CD   CE   NZ
 DIHEdral CD   CE   NZ   HZ1  !!
 DIHEdral CD   CE   NZ   HZ2  !!note: dihedrals for each hydrogen
 DIHEdral CD   CE   NZ   HZ3  !!

 IMPRoper CA   N    C    CB  !tetrahedral CA

 DONOr H    N
 DONOr HZ1  NZ
 DONOr HZ2  NZ
 DONOr HZ3  NZ
 ACCEptor O C


END {LYS}

!------------------------------------------------------------------

RESIdue MET
 GROUp
  ATOM N    TYPE=NH1   CHARge=-0.35   END
  ATOM H    TYPE=H     CHARge= 0.25   END
  ATOM CA   TYPE=CH1E  CHARge= 0.10   END
 GROUp 
  ATOM CB   TYPE=CH2E  CHARge= 0.00   END
 GROUp
  ATOM CG   TYPE=CH2E  CHARge= 0.06   END
  ATOM SD   TYPE=S     CHARge=-0.12   END
  ATOM CE   TYPE=CH3E  CHARge= 0.06   END
 GROUp
  ATOM C    TYPE=C     CHARge= 0.55   END  !#
  ATOM O    TYPE=O     CHARge=-0.55   END  !#

 BOND N    CA
 BOND CA   C
 BOND C    O
 BOND N    H
 BOND CA   CB
 BOND CB   CG
 BOND CG   SD
 BOND SD   CE

 DIHEdral N    CA   CB   CG
 DIHEdral CA   CB   CG   SD
 DIHEdral CB   CG   SD   CE

 IMPRoper CA   N    C    CB  !tetrahedral CA

 DONOr H    N
 ACCEptor O C


END {MET}

!------------------------------------------------------------------
RESIdue PEN  ! Penicillamine
 GROUp
  ATOM N    TYPE=NH1   CHARGE=-0.35   END
  ATOM H    TYPE=H     CHARGE=0.25    END
  ATOM CA   TYPE=CH1E  CHARGE=0.10    END
 GROUp
  ATOM CB   TYPE=CT    CHARGE=0.19    END
  ATOM CG1  TYPE=CH3E  CHARGE=0.0     END
  ATOM CG2  TYPE=CH3E  CHARGE=0.0     END
  ATOM SG   TYPE=SH1E  CHARGE=-0.19   END
 GROUp
  ATOM C    TYPE=C     CHARGE=0.55    END
  ATOM O    TYPE=O     CHARGE=-0.55   END

 BOND N    CA      BOND CA   C     BOND C    O      BOND N    H
 BOND CA   CB      BOND CB   SG    BOND CB   CG1    BOND CB   CG2

 DIHEdral N    CA   CB   SG
 IMPRoper CA   N    C    CB  !tetrahedral CA

 DONOr  H  N
 ACCEptor  O  C

END {* PEN *}

!------------------------------------------------------------------

RESIdue PHE
 GROUp
  ATOM N    TYPE=NH1   CHARge=-0.35   END
  ATOM H    TYPE=H     CHARge= 0.25   END
  ATOM CA   TYPE=CH1E  CHARge= 0.10   END
 GROUp
  ATOM CB   TYPE=CH2E  CHARge= 0.00   END
  ATOM CG   TYPE=C     CHARge= 0.00   EXCLusion=( CZ ) END
  ATOM CD1  TYPE=CR1E  CHARge= 0.00   EXCLusion=( CE2 ) END
  ATOM CD2  TYPE=CR1E  CHARge= 0.00   EXCLusion=( CE1 ) END
 GROUp
  ATOM CE1  TYPE=CR1E  CHARge= 0.00   END
  ATOM CE2  TYPE=CR1E  CHARge= 0.00   END
  ATOM CZ   TYPE=CR1E  CHARge= 0.00   END
 GROUp 
  ATOM C    TYPE=C     CHARge= 0.55   END  !#
  ATOM O    TYPE=O     CHARge=-0.55   END  !#

 BOND N    CA
 BOND CA   C
 BOND C    O
 BOND N    H
 BOND CA   CB
 BOND CB   CG
 BOND CG   CD1
 BOND CG   CD2
 BOND CD1  CE1
 BOND CD2  CE2
 BOND CE1  CZ
 BOND CE2  CZ

 DIHEdral N    CA   CB   CG
 DIHEdral CA   CB   CG   CD1  !note: only one dihedral around CB-CG

 IMPRoper CA   N    C    CB  !tetrahedral CA
 IMPRoper CG   CD1  CD2  CB  !planar CG

 IMPRoper CG   CD1  CE1  CZ  !!
 IMPRoper CD1  CE1  CZ   CE2 !!
 IMPRoper CE1  CZ   CE2  CD2 !! ring torsions
 IMPRoper CZ   CE2  CD2  CG  !!
 IMPRoper CE2  CD2  CG   CD1 !!
 IMPRoper CD2  CG   CD1  CE1 !!

 DONOr H    N
 ACCEptor O C


END {PHE}

!------------------------------------------------------------------

RESIdue PRO
 GROUp
  ATOM N    TYPE=N     CHARge=-0.20   END
  ATOM CD   TYPE=CH2E  CHARge= 0.10   END
  ATOM CA   TYPE=CH1E  CHARge= 0.10   END
 GROUp
  ATOM CB   TYPE=CH2E  CHARge= 0.00   END
  ATOM CG   TYPE=CH2E  CHARge= 0.00   END
 GROUp
  ATOM C    TYPE=C     CHARge= 0.55   END
  ATOM O    TYPE=O     CHARge=-0.55   END

 BOND N    CA
 BOND CA   C 
 BOND C    O
 BOND N    CD
 BOND CA   CB
 BOND CB   CG
 BOND CG   CD

 DIHEdral N    CA   CB   CG  !! 
 DIHEdral CA   CB   CG   CD  !!
 DIHEdral CB   CG   CD   N   !! the PROline ring is represented by dihedrals
 DIHEdral CG   CD   N    CA  !!

 IMPRoper CA   N    C    CB  !tetrahedral CA

 ACCEptor O C


END {PRO}

!------------------------------------------------------------------

RESIdue SER
 GROUp
  ATOM N    TYPE=NH1   CHARge=-0.35   END
  ATOM H    TYPE=H     CHARge= 0.25   END
  ATOM CA   TYPE=CH1E  CHARge= 0.10   END
 GROUp
  ATOM CB   TYPE=CH2E  CHARge= 0.25   END  !#
  ATOM OG   TYPE=OH1   CHARge=-0.65   END  !#
  ATOM HG   TYPE=H     CHARge= 0.40   END  !#
 GROUp
  ATOM C    TYPE=C     CHARge= 0.55   END  !#
  ATOM O    TYPE=O     CHARge=-0.55   END  !#

 BOND N    CA
 BOND CA   C
 BOND C    O
 BOND N    H
 BOND CA   CB
 BOND CB   OG
 BOND OG   HG

 DIHEdral N    CA   CB   OG
 DIHEdral CA   CB   OG   HG

 IMPRoper CA   N    C    CB  !tetrahedral CA

 DONOr H    N
 DONOr HG   OG 
 ACCEptor OG " "
 ACCEptor O C


END {SER}

!------------------------------------------------------------------

RESIdue SED   ! Serine modified with DT6 (Diacetamido-2,4,6-trideoxyhexose),
              ! you can find the patch down. 
 GROUp        
  ATOM N    TYPE=NH1   CHARge=-0.35   END
  ATOM H    TYPE=H     CHARge= 0.25   END
  ATOM CA   TYPE=CH1E  CHARge= 0.10   END
 GROUp
  ATOM CB   TYPE=CH2E  CHARge= 0.25   END  !#
  ATOM OG   TYPE=OH1   CHARge=-0.65   END  !#
  ATOM HG   TYPE=H     CHARge= 0.40   END  !#
 GROUp
  ATOM C    TYPE=C     CHARge= 0.55   END  !#
  ATOM O    TYPE=O     CHARge=-0.55   END  !#

 BOND N    CA
 BOND CA   C
 BOND C    O
 BOND N    H
 BOND CA   CB
 BOND CB   OG
 BOND OG   HG

 DIHEdral N    CA   CB   OG
 DIHEdral CA   CB   OG   HG

 IMPRoper CA   N    C    CB  !tetrahedral CA

 DONOr H    N
 DONOr HG   OG 
 ACCEptor OG " "
 ACCEptor O C


END {SED}

!------------------------------------------------------------------

RESIdue SEG   ! Serine modified with GT6 (Glyceramido acetamido trideoxy-hexose),
              ! you can find the patch down. 
 GROUp
  ATOM N    TYPE=NH1   CHARge=-0.35   END
  ATOM H    TYPE=H     CHARge= 0.25   END
  ATOM CA   TYPE=CH1E  CHARge= 0.10   END
 GROUp
  ATOM CB   TYPE=CH2E  CHARge= 0.25   END  !#
  ATOM OG   TYPE=OH1   CHARge=-0.65   END  !#
  ATOM HG   TYPE=H     CHARge= 0.40   END  !#
 GROUp
  ATOM C    TYPE=C     CHARge= 0.55   END  !#
  ATOM O    TYPE=O     CHARge=-0.55   END  !#

 BOND N    CA
 BOND CA   C
 BOND C    O
 BOND N    H
 BOND CA   CB
 BOND CB   OG
 BOND OG   HG

 DIHEdral N    CA   CB   OG
 DIHEdral CA   CB   OG   HG

 IMPRoper CA   N    C    CB  !tetrahedral CA

 DONOr H    N
 DONOr HG   OG 
 ACCEptor OG " "
 ACCEptor O C


END {SEG}

!------------------------------------------------------------------

RESIdue SEO   ! Serine modified with OPE (Colamine Phosphoric Acid),
              ! you can find the patch down.
 GROUp
  ATOM N    TYPE=NH1   CHARge=-0.35   END
  ATOM H    TYPE=H     CHARge= 0.25   END
  ATOM CA   TYPE=CH1E  CHARge= 0.10   END
 GROUp
  ATOM CB   TYPE=CH2E  CHARge= 0.25   END  !#
  ATOM OG   TYPE=OH1   CHARge=-0.65   END  !#
  ATOM HG   TYPE=H     CHARge= 0.40   END  !#
 GROUp
  ATOM C    TYPE=C     CHARge= 0.55   END  !#
  ATOM O    TYPE=O     CHARge=-0.55   END  !#

 BOND N    CA
 BOND CA   C
 BOND C    O
 BOND N    H
 BOND CA   CB
 BOND CB   OG
 BOND OG   HG

 DIHEdral N    CA   CB   OG
 DIHEdral CA   CB   OG   HG

 IMPRoper CA   N    C    CB  !tetrahedral CA

 DONOr H    N
 DONOr HG   OG 
 ACCEptor OG " "
 ACCEptor O C


END {SEO}

!------------------------------------------------------------------

RESIdue SEP   ! Serine modified with PGL (PhosphoGlycerol),
              ! you can find the patch down.
 GROUp
  ATOM N    TYPE=NH1   CHARge=-0.35   END
  ATOM H    TYPE=H     CHARge= 0.25   END
  ATOM CA   TYPE=CH1E  CHARge= 0.10   END
 GROUp
  ATOM CB   TYPE=CH2E  CHARge= 0.25   END  !#
  ATOM OG   TYPE=OH1   CHARge=-0.65   END  !#
  ATOM HG   TYPE=H     CHARge= 0.40   END  !#
 GROUp
  ATOM C    TYPE=C     CHARge= 0.55   END  !#
  ATOM O    TYPE=O     CHARge=-0.55   END  !#

 BOND N    CA
 BOND CA   C
 BOND C    O
 BOND N    H
 BOND CA   CB
 BOND CB   OG
 BOND OG   HG

 DIHEdral N    CA   CB   OG
 DIHEdral CA   CB   OG   HG

 IMPRoper CA   N    C    CB  !tetrahedral CA

 DONOr H    N
 DONOr HG   OG 
 ACCEptor OG " "
 ACCEptor O C


END {SEP}

!------------------------------------------------------------------

RESIdue THR
 GROUp
  ATOM N    TYPE=NH1   CHARge=-0.35   END
  ATOM H    TYPE=H     CHARge= 0.25   END
  ATOM CA   TYPE=CH1E  CHARge= 0.10   END
 GROUp
  ATOM CB   TYPE=CH1E  CHARge= 0.25   END  !#
  ATOM OG1  TYPE=OH1   CHARge=-0.65   END  !#
  ATOM HG1  TYPE=H     CHARge= 0.40   END  !#masse phosphate
 GROUp
  ATOM CG2  TYPE=CH3E  CHARge= 0.00   END
 GROUp
  ATOM C    TYPE=C     CHARge= 0.55   END  !#
  ATOM O    TYPE=O     CHARge=-0.55   END  !#

 BOND N    CA
 BOND CA   C
 BOND C    O
 BOND N    H
 BOND CA   CB
 BOND CB   OG1
 BOND CB   CG2
 BOND OG1  HG1

 DIHEdral N    CA   CB   OG1  !note: only one dihedral around CA-CB
 DIHEdral CA   CB   OG1  HG1

 IMPRoper CA   N    C    CB  !tetrahedral CA
 IMPRoper CB   OG1  CG2  CA  !planar CB

 DONOr H    N
 DONOr HG1  OG1
 ACCEptor OG1 " "
 ACCEptor O C


END {THR}

!------------------------------------------------------------------

RESIdue TRP
 GROUp
  ATOM N    TYPE=NH1   CHARge=-0.35   END
  ATOM H    TYPE=H     CHARge= 0.25   END
  ATOM CA   TYPE=CH1E  CHARge= 0.10   END
 GROUp 
  ATOM CB   TYPE=CH2E  CHARge= 0.00   END
 GROUp
  ATOM CG   TYPE=C     CHARge=-0.03  EXCL=(CD1 CD2 NE1 CE2 CE3 CZ2 CZ3 CH2) END
  ATOM CD2  TYPE=C     CHARge= 0.10  EXCL=(NE1 CE2 CE3 CZ2 CZ3 CH2)         END
  ATOM CE2  TYPE=C     CHARge=-0.04  EXCL=(CE3 CZ2 CZ3 CH2)                 END
  ATOM CE3  TYPE=CR1E  CHARge=-0.03  EXCL=(CZ2 CZ3 CH2)                     END
 GROUp
  ATOM CD1  TYPE=CR1E  CHARge= 0.06  EXCL=(CD2 NE1 CE2 CE3 CZ2 CZ3 CH2) END !#
  ATOM NE1  TYPE=NH1   CHARge=-0.36  EXCL=(CE2 CE3 CZ2 CZ3 CH2)         END !#
  ATOM HE1  TYPE=H     CHARge= 0.30   END                                   !#
 GROUp 
  ATOM CZ2  TYPE=CR1E  CHARge= 0.00  EXCL=(CZ3 CH2)    END
  ATOM CZ3  TYPE=CR1E  CHARge= 0.00  EXCL=(CH2)        END
  ATOM CH2  TYPE=CR1E  CHARge= 0.00   END
 GROUp
  ATOM C    TYPE=C     CHARge= 0.55   END
  ATOM O    TYPE=O     CHARge=-0.55   END

 BOND N    CA
 BOND CA   C
 BOND C    O
 BOND N    H
 BOND CA   CB
 BOND CB   CG
 BOND CG   CD1
 BOND CG   CD2
 BOND CD1  NE1
 BOND CD2  CE2
 BOND NE1  HE1
 BOND NE1  CE2
 BOND CD2  CE3
 BOND CE2  CZ2
 BOND CE3  CZ3
 BOND CZ2  CH2
 BOND CZ3  CH2

 OMIT ANGLe CG CD2 CE3
 OMIT ANGLe NE1 CE2 CZ2
! The ring angles are only assigned for the five and six member rings.
! The angles CG CD2 CE3  and NE1 CE2 CZ2 are left out to avoid conflicts
! with the histidine angle parameters and to preserve symmetry.

 DIHEdral N    CA   CB   CG
 DIHEdral CA   CB   CG   CD1
 DIHEdral CD1  CE2  CD2  CZ3  !!
 DIHEdral CD1  CD2  CE2  CH2  !! these dihedrals span the rings and keep
 DIHEdral CZ2  CE2  CD2  CG   !! them parallel
 DIHEdral CE3  CD2  CE2  NE1  !!

 IMPRoper CA   N    C    CB   !tetrahedral CA
 IMPRoper CG   CD1  CD2  CB   !planar CG
 IMPRoper NE1  CD1  CE2  HE1  !planar NE1

 IMPRoper CD2  CE2  CZ2  CH2  !!
 IMPRoper CE2  CZ2  CH2  CZ3  !!
 IMPRoper CZ2  CH2  CZ3  CE3  !! torsions ring 2
 IMPRoper CH2  CZ3  CE3  CD2  !!
 IMPRoper CZ3  CE3  CD2  CE2  !!
 IMPRoper CE3  CD2  CE2  CZ2  !!

 IMPRoper CG   CD1  NE1  CE2  !!
 IMPRoper CD1  NE1  CE2  CD2  !!
 IMPRoper NE1  CE2  CD2  CG   !! torsions ring 1
 IMPRoper CE2  CD2  CG   CD1  !!
 IMPRoper CD2  CG   CD1  NE1  !!

 DONOr H    N
 DONOr HE1  NE1
 ACCEptor O C


END {THR}

!------------------------------------------------------------------

RESIdue TYR
 GROUp
  ATOM N    TYPE=NH1   CHARge=-0.35   END
  ATOM H    TYPE=H     CHARge= 0.25   END
  ATOM CA   TYPE=CH1E  CHARge= 0.10   END
 GROUp
  ATOM CB   TYPE=CH2E  CHARge= 0.00   END
  ATOM CG   TYPE=C     CHARge= 0.00  EXCLusion=( CZ )  END
 GROUp
  ATOM CD1  TYPE=CR1E  CHARge= 0.00  EXCLusion=( CE2 ) END
  ATOM CE1  TYPE=CR1E  CHARge= 0.00  EXCLusion=( CD2 ) END
 GROUp
  ATOM CD2  TYPE=CR1E  CHARge= 0.00  END
  ATOM CE2  TYPE=CR1E  CHARge= 0.00  END
 GROUp
  ATOM CZ   TYPE=C     CHARge= 0.25  END
  ATOM OH   TYPE=OH1   CHARge=-0.65  END
  ATOM HH   TYPE=H     CHARge= 0.40  END
 GROUp
  ATOM C    TYPE=C     CHARge= 0.55  END
  ATOM O    TYPE=O     CHARge=-0.55  END

 BOND N    CA
 BOND CA   C
 BOND C    O
 BOND N    H
 BOND CA   CB
 BOND CB   CG
 BOND CG   CD1
 BOND CG   CD2
 BOND CD1  CE1
 BOND CD2  CE2
 BOND CE1  CZ 
 BOND CE2  CZ
 BOND CZ   OH
 BOND OH   HH

 DIHEdral N    CA   CB   CG
 DIHEdral CA   CB   CG   CD1
 DIHEdral CE2  CZ   OH   HH

 IMPRoper CA   N    C    CB !tetrahedral CA
 IMPRoper CG   CD1  CD2  CB !planar CG
 IMPRoper CZ   CE1  CE2  OH !planar CZ

 IMPRoper CG   CD1  CE1  CZ  !!
 IMPRoper CD1  CE1  CZ   CE2 !!
 IMPRoper CE1  CZ   CE2  CD2 !! ring torsions
 IMPRoper CZ   CE2  CD2  CG  !!
 IMPRoper CE2  CD2  CG   CD1 !!
 IMPRoper CD2  CG   CD1  CE1 !!

 DONOr H    N
 DONOr HH   OH
 ACCEptor OH " "
 ACCEptor O C


END {TYR}

!------------------------------------------------------------------

RESIdue VAL
 GROUp
  ATOM N    TYPE=NH1   CHARge=-0.35   END
  ATOM H    TYPE=H     CHARge= 0.25   END
  ATOM CA   TYPE=CH1E  CHARge= 0.10   END
 GROUp
  ATOM CB   TYPE=CH1E  CHARge= 0.00   END
  ATOM CG1  TYPE=CH3E  CHARge= 0.00   END
  ATOM CG2  TYPE=CH3E  CHARge= 0.00   END
 GROUp
  ATOM C    TYPE=C     CHARge= 0.55   END
  ATOM O    TYPE=O     CHARge=-0.55   END

 BOND N    CA
 BOND CA   C
 BOND C    O
 BOND N    H
 BOND CA   CB
 BOND CB   CG1
 BOND CB   CG2

 DIHEdral N    CA   CB   CG1  !note: only one dihedral around CA-CB

 IMPRoper CA   N    C    CB  !tetrahedral CA
 IMPRoper CB   CG2  CG1  CA  !planar CB

 DONOr H    N
 ACCEptor O C


END {VAL}

!------------------------------------------------------------------

RESIdue FORM  ! formamide. Charges according to Reiher (from States?)
 GROUp
  ATOM HA   TYPE=HA    CHARge= 0.00   END
 GROUp
  ATOM C    TYPE=C     CHARge= 0.55   END
  ATOM O    TYPE=O     CHARge=-0.55   END
 GROUp
  ATOM N    TYPE=NH2   CHARge=-0.60   END
  ATOM H1   TYPE=H     CHARge= 0.30   END
  ATOM H2   TYPE=H     CHARge= 0.30   END

 BOND HA   C       BOND C     N      BOND C    O
 BOND N    H2      BOND N    H1

 DIHEdral  HA   C     N   H2  !single dihedral around C-N
 IMPRoper  C    HA    N   O   !planar C
 IMPRoper  N     C   H2   H1  !planar N

 ACCEptor O  C
 DONOr    H1 N

END {* FORM *}

!------------------------------------------------------------------

RESIdue ACE      { Acetyl blocking GROUp with standard naming.
                   can be linked:  ACE       *
                                     \ PEPT /                  }
 GROUp
  ATOM CA   TYPE=CH3E  CHARge= 0.00   END
 GROUp
  ATOM C    TYPE=C     CHARge= 0.55   END  !#
  ATOM O    TYPE=O     CHARge=-0.55   END  !#

 BOND CA   C
 BOND C    O

 ACCEptor O C

END {ACE}

!------------------------------------------------------------------

RESIdue CBX                 { can be linked   *     CBX 
                                               \PEPT/     }
 GROUp
  ATOM N    TYPE=NH1   CHARge=-0.35   END
  ATOM H    TYPE=H     CHARge= 0.25   END
  ATOM CA   TYPE=CH3E  CHARge= 0.10   END

 BOND N    CA
 BOND N    H

 DONOr H    N

END {CBX}

!----------------------------------------------------------------------

RESIdue SO4         { sulfate group }
 GROUp
  ATOM S    TYPE=S   CHARge= 0.0   END
  ATOM O1   TYPE=OC  CHARge=-0.5   END
  ATOM O2   TYPE=OC  CHARge=-0.5   END
  ATOM O3   TYPE=OC  CHARge=-0.5   END
  ATOM O4   TYPE=OC  CHARge=-0.5   END

 BOND S O1
 BOND S O2
 BOND S O3
 BOND S O4

 ACCEptor O1 S
 ACCEptor O2 S
 ACCEptor O3 S
 ACCEptor O4 S

END {SO4}



!------------------------------------------------------------------


PRES NTME          {adapted from aminoh.top by MN July 2006}
		   ! can be patched ( as NTME - * )
		   ! This patch adds a single methyl group to the N-terminal
		   ! This patch will not work with PRO as the first residue
		   ! Apply this patch ONLY after the NTER patch has been applied
GROUp
  ADD ATOM  CNT  type= CH3E charge= 0.35 end
  MODIFY ATOM N  TYPE= NH1               END
  DELE ATOM  HT3                        end
  ADD BOND  N CNT   
  ADD ANGLE CA N CNT
  ADD ANGLE HT1 N CNT   
  ADD ANGLE HT2 N CNT
  ADD DIHE  C CA N CNT
end



!------------------------------------------------------------------

PRES GLUA   ! Patch to change deprotonated GLU to protonated glutamate
            ! has to be patched as REFErence=NIL=<selection>
GROUp
 MODIFY ATOM  CB   TYPE=CH2E  CHARge= 0.10   END  !#
GROUp
 MODIFY ATOM  CG   TYPE=CH2E  CHARge= 0.15   END  !#
 MODIFY ATOM  CD   TYPE=C     CHARge= 0.40   END  !#
 MODIFY ATOM  OE1  TYPE=OC    CHARge=-0.40   END  !#
 MODIFY ATOM  OE2  TYPE=OH1   CHARge=-0.50   END  !#
 ADD    ATOM  HE   TYPE=H     CHARge= 0.25   END  !#

 ADD BOND OE2 HE
 ADD ANGLe CD OE2 HE
 ADD DIHEdral OE1 CD OE2 HE

 DELETE ACCEptor OE2 CD

 ADD DONOr HE OE2

END {GLUA}

!------------------------------------------------------------------


PRESidue DISU       { disulfide bridge  ...CYS      CYS...
                                              \DISU/            }
 GROUP
  MODIfy ATOM 1CB           CHARge= 0.19  END
  MODIfy ATOM 1SG  TYPE=S   CHARge=-0.19  END
 GROUP
  MODIfy ATOM 2CB           CHARge= 0.19  END
  MODIfy ATOM 2SG  TYPE=S   CHARge=-0.19  END

 ADD BOND 1SG 2SG

 ADD ANGLe  1CB 1SG 2SG
 ADD ANGLe  1SG 2SG 2CB

 ADD DIHEdral   1CA 1CB 1SG 2SG
 ADD DIHEdral   1CB 1SG 2SG 2CB
 ADD DIHEdral   1SG 2SG 2CB 2CA


END {DISU}

!----------------------------------------------------------------------

PRESidue LtoD  {* patch to make D residue, from M. Pettitt *}
 DELEte IMPRoper CA N C CB
 ADD    IMPRoper CA C N CB
END {* LtoD *}

!----------------------------------------------------------------------
PRESidue PGGA { PEPTide bond link, for g-glutamic-acid (guess by MN,IP)}
! charges based on the PEPT and GLN 

  MODIfy   ATOM -C               CHARge= 0.55  END
  ADD      ATOM -O1    TYPE=OC   CHARge=-0.35  END
  ADD      ATOM -O2    TYPE=OH1  CHARge=-0.45  END
  ADD      ATOM -HO2   TYPE=H    CHARge= 0.25  END 
  DELETE   ATOM -O                             END
  DELETE   ATOM -OE2                           END

  MODIFY ATOM -CG              CHARge= 0.00   END !#
  MODIFY ATOM -CD              CHARge= 0.55   END !#
  MODIFY ATOM -OE1  TYPE=O     CHARge=-0.55   END !#
  MODIFY ATOM -N    TYPE=NH1   CHARge=-0.35   END
  MODIFY ATOM -H    TYPE=H     CHARge= 0.25   END

 ADD BOND -C    -O1   ! attach the cooh group
 ADD BOND -C    -O2
 ADD BOND -O2   -HO2
 
 ADD BOND -CD +N      ! link between the amide and the delta carbon

 ADD ANGLe -CA   -C   -O1
 ADD ANGLe -CA   -C   -O2
 ADD ANGLe -O1   -C   -O2
 ADD ANGLe -C    -O2   -HO2

 ADD ANGLE -CG  -CD +N
 ADD ANGLE -OE1 -CD +N
 ADD ANGLE -CD   +N +CA
 ADD ANGLE -CD   +N +H

 ADD DIHEdral  -CD +N +CA +C   ! =^ -C +N +CA +C, psi
 ADD DIHEdral  -CB -CG -CD +N  ! =^ -N -CA -C +N, phi
 ADD DIHEdral  -CG -CD +N +CA  ! =^ -CA -C +N +CA, omega

 ADD DIHEdral -O1 -C -O2 -HO2

 ADD    IMPRoper     -C -CA  -O2 -O1 {planar C}
 ADD    IMPRoper    -CD -CG +N -OE1  {planar -CD}
 ADD    IMPRoper     +N -CD +CA +H   {planar +N}

 ADD ACCEptor -O1   -C    ! for analysis
 ADD DONOr    -HO2 -O2
END {PGGA}

!----------------------------------------------------------------------

PRESidue PEPT { PEPTide bond link, for all 
               amino acids ...*(-)     (+)*...
                                \ PEPT /

               except the  *(-) - (+)PRO link        }

 ADD BOND -C +N 

 ADD ANGLE -CA -C +N
 ADD ANGLE -O  -C +N
 ADD ANGLE -C  +N +CA
 ADD ANGLE -C  +N +H

 ADD DIHEdral  -C +N +CA +C
 ADD DIHEdral  -N -CA -C +N
 ADD DIHEdral  -CA -C +N +CA

 ADD IMPRoper  -C -CA +N -O  {planar -C}
 ADD IMPRoper  +N -C +CA +H  {planar +N}


END {PEPT}

!----------------------------------------------------------------------
PRESidue PEPP  { for  ...*(-) - (+)PRO  link
               same as PEPT except replacement H by CD
               and improper +N +CA +CD -C              }

 ADD BOND -C +N 

 ADD ANGLE -CA -C +N
 ADD ANGLE -O  -C +N
 ADD ANGLE -C  +N +CA
 ADD ANGLE -C  +N +CD

 ADD DIHEdral  -C +N +CA +C
 ADD DIHEdral  -N -CA -C +N
 ADD DIHEdral  -CA -C +N +CA

 ADD IMPRoper  -C -CA +N -O  {planar -C}
 ADD IMPRoper  +N +CA +CD -C  {planar +N}


END {PEPP}

!------------------------------------------------------------------

PRESidue NTER             { can be patched ( as NTER - * ... )
                            to any amino acid except PRO        }
 GROUp
  ADD    ATOM +HT1  TYPE=HC   CHARge=0.35  END
  ADD    ATOM +HT2  TYPE=HC   CHARge=0.35  END
  MODIfy ATOM +N    TYPE=NH3  CHARge=-0.30 END
  ADD    ATOM +HT3  TYPE=HC   CHARge=0.35  END
  DELETE ATOM +H                           END
  MODIfy ATOM +CA             CHARge=0.25  END

 ADD BOND +HT1 +N
 ADD BOND +HT2 +N
 ADD BOND +HT3 +N

 ADD ANGLe +HT1  +N    +HT2
 ADD ANGLe +HT2  +N    +HT3
 ADD ANGLe +HT2  +N    +CA
 ADD ANGLe +HT1  +N    +HT3
 ADD ANGLe +HT1  +N    +CA
 ADD ANGLe +HT3  +N    +CA

 ADD DIHEdral +HT2  +N    +CA   +C
 ADD DIHEdral +HT1  +N    +CA   +C
 ADD DIHEdral +HT3  +N    +CA   +C

 ADD DONOr +HT1  +N
 ADD DONOr +HT2  +N
 ADD DONOr +HT3  +N


END {NTER}

!------------------------------------------------------------------

PRESidue PROP                { this is the N-terminal for PROlines
                               PROP - PRO -...                      }
 GROUp
  ADD    ATOM +HT1  TYPE=HC   CHARge= 0.35   END
  ADD    ATOM +HT2  TYPE=HC   CHARge= 0.35   END
  MODIfy ATOM +N    TYPE=NH3  CHARge=-0.20   END
  MODIfy ATOM +CD             CHARge= 0.25   END
  MODIfy ATOM +CA             CHARge= 0.25   END

 ADD BOND +HT1  +N
 ADD BOND +HT2  +N

 ADD ANGLe +HT1  +N    +HT2
 ADD ANGLe +HT2  +N    +CA
 ADD ANGLe +HT1  +N    +CD
 ADD ANGLe +HT1  +N    +CA
 ADD ANGLe +CD   +N    +HT2

 ADD DIHEdral +HT2  +N    +CA   +C
 ADD DIHEdral +HT1  +N    +CA   +C

 ADD DONOr +HT1  +N
 ADD DONOr +HT2  +N


END {PROP}

!------------------------------------------------------------------

PRESidue CTER                { C-terminal for all amino acids
                                           ... * - CTER          }
 GROUp
  MODIfy ATOM -C             CHARge= 0.14  END
  ADD    ATOM -OT1  TYPE=OC  CHARge=-0.57  END
  ADD    ATOM -OT2  TYPE=OC  CHARge=-0.57  END
  DELETE ATOM -O                           END

 ADD BOND -C    -OT1
 ADD BOND -C    -OT2

 ADD ANGLe -CA   -C   -OT1
 ADD ANGLe -CA   -C   -OT2
 ADD ANGLe -OT1  -C   -OT2

 ADD DIHEdral -N    -CA    -C   -OT2

 ADD IMPRoper -C    -CA    -OT2 -OT1

 ADD ACCEptor -OT1 -C

 ADD ACCEptor -OT2 -C


END {CTER}


!-----------------------------------------------------------------------

PRESidue HISE   ! Patch to change doubly protonated HIS to singly
                ! protonated histidine (HE2)
                ! has to be patched as REFErence=NIL=<selection>
                        
 GROUP
  MODIFY ATOM  CB   TYPE=CH2E  CHARge= 0.0   END
 GROUP
  MODIFY ATOM  CG   TYPE=C     CHARge= 0.10  END !#
  MODIFY ATOM  ND1  TYPE=NR    CHARge=-0.40  END !#
  MODIFY ATOM  CE1  TYPE=CR1E  CHARge= 0.30  END !#
 GROUP
  MODIFY ATOM  CD2  TYPE=CR1E  CHARge= 0.10  END
  MODIFY ATOM  NE2  TYPE=NH1   CHARge=-0.40  END !#
  MODIFY ATOM  HE2  TYPE=H     CHARge= 0.30  END !#
  DELETE ATOM  HD1                           END

 ADD ACCEPTOR  ND1 " "

END {HISE}

!--------------------------------------------------------------------------

PRES HISD   ! Patch to change doubly protonated HIS to singly
            ! protonated histidine (HD1)
            ! has to be patched as REFErence=NIL=<selection>
 GROUP
  MODIFY ATOM  CB   TYPE=CH2E  CHARge= 0.00  END
 GROUP
  MODIFY ATOM  CG   TYPE=C     CHARge= 0.10  END  !#
  MODIFY ATOM  ND1  TYPE=NH1   CHARge=-0.40  END  !#
  MODIFY ATOM  HD1  TYPE=H     CHARge= 0.30  END  !#
 GROUP
  MODIFY ATOM  CD2  TYPE=CR1E  CHARge= 0.10  END  !#
  MODIFY ATOM  NE2  TYPE=NR    CHARge=-0.40  END  !#
  MODIFY ATOM  CE1  TYPE=CR1E  CHARge= 0.30  END  !#
  DELETE ATOM  HE2                        END

 ADD ACCEPTOR  NE2 " "

END {HISD}

!-----------------------------------------------------------------------

PRES HIST     !  INVERSE PATCH TO HISD
              !  has to be patched as REFErence=NIL=<selection>

 GROUP 
  MODIFY ATOM  CB   TYPE=CH2E    CHARge= 0.10  END
  MODIFY ATOM  CG   TYPE=C       CHARge= 0.15  END
  MODIFY ATOM  CD2  TYPE=CR1E    CHARge= 0.20  END
 GROUP
  MODIFY ATOM  ND1  TYPE=NH1     CHARge=-0.30  END  !#
  MODIFY ATOM  HD1  TYPE=H       CHARge= 0.35  END  !#
 GROUP
  MODIFY ATOM  CE1  TYPE=CR1E    CHARge= 0.45  END  !#
 GROUP
  MODIFY ATOM  NE2  TYPE=NH1     CHARge=-0.30  END  !#
  ADD    ATOM  HE2  TYPE=H       CHARge= 0.35  END  !#

 ADD BOND  NE2  HE2

 ADD ANGLE  HE2  NE2  CD2
 ADD ANGLE  HE2  NE2  CE1

 ADD IMPROPER  NE2  CE1  CD2  HE2

 ADD DONOR   HE2  NE2
 DELETE ACCEPTOR  NE2 " "

END {HISD}

!---------------------------------------------------------------------

PRESIDUE HISU   ! INVERSE PATCH TO HISE
                ! has to be patched as REFErence=NIL=<selection>

 GROUP
  MODIFY ATOM  CB   TYPE=CH2E   CHARge= 0.10  END
  MODIFY ATOM  CG   TYPE=C      CHARge= 0.15  END
  MODIFY ATOM  CD2  TYPE=CR1E   CHARge= 0.20  END
 GROUP
  MODIFY ATOM  ND1  TYPE=NH1    CHARge=-0.30  END
  ADD ATOM  HD1     TYPE=H      CHARge= 0.35  END
 GROUP
  MODIFY ATOM  CE1  TYPE=CR1E   CHARge= 0.45  END
 GROUP
  MODIFY ATOM  NE2  TYPE=NH1    CHARge=-0.30  END
  MODIFY ATOM  HE2  TYPE=H      CHARge= 0.35  END

 ADD BOND  ND1    HD1

 ADD ANGLE  CG  ND1  HD1
 ADD ANGLE  HD1  ND1  CE1

 ADD IMPROPER   ND1  CG  CE1  HD1

 ADD DONOR   HD1  ND1
 DELETE ACCEPTOR  ND1 " "

END {HISU}

!------------------------------------------------------------------
PRESidue PGL      ! PGL (Phosphoglycerol) group patched to SER
                  ! PURE GUESS based on MIP in toph19.his (M Nilges)
                  !
                  ! has to be patched as REFErence=NIL=<selection>
 GROUP            ! 
  MODIFY ATOM  CB  TYPE=CH2E              END!                CA (SER)
  DELETE ATOM  HG                         END!                |
 GROUP                                       !                CB (SER)
  MODIFY ATOM  OG  TYPE=OS   CHARge=-0.27 END!                |
  ADD    ATOM  PD  TYPE=P    CHARge= 0.52 END!                OG
  ADD    ATOM  OD1 TYPE=O2   CHARge=-0.49 END!                |      (-)
  ADD    ATOM  OD2 TYPE=O2   CHARge=-0.49 END!         OD1 -- PD -- OD2
  ADD    ATOM  OE  TYPE=OS   CHARge=-0.27 END!                |
 GROUP                                       !                OE
  ADD    ATOM  CZ  TYPE=CH2E CHARge= 0.0  END!                | 
 GROUP                                       !                CZ
  ADD    ATOM  CH  TYPE=CH1E CHARGE= 0.25 END!                |      
  ADD    ATOM  OH1 TYPE=OH1  CHARGE=-0.65 END!                CH-OH1-HH1
  ADD    ATOM  HH1 TYPE=H    CHARGE= 0.40 END!                |
 GROUP                                       !                CI-OI1-HI1
  ADD    ATOM  CI  TYPE=CH2E CHARGE= 0.25 END!                                 
  ADD    ATOM  OI1 TYPE=OH1  CHARGE=-0.65 END! 
  ADD    ATOM  HI1 TYPE=H    CHARGE= 0.40 END!   
!
BOND    OG   PD
BOND    PD   OD2
BOND    PD   OD1
BOND    PD   OE
BOND    OE   CZ
BOND    CZ   CH
BOND    CH   OH1
BOND    OH1  HH1
BOND    CH   CI
BOND    CI   OI1
BOND    OI1  HI1

ADD ANGLE   CB  OG  PD
ADD ANGLE   OG  PD  OD2
ADD ANGLE   OG  PD  OD1
ADD ANGLE   OG  PD  OE
ADD ANGLE   OD1 PD  OE 
ADD ANGLE   OD1 PD  OD2
ADD ANGLE   OE  PD  OD2
ADD ANGLE   PD  OE  CZ
ADD ANGLE   OE  CZ  CH 
ADD ANGLE   CZ  CH  OH1
ADD ANGLE   CZ  CH  CI
ADD ANGLE   CH  OH1 HH1
ADD ANGLE   CH  CI  OI1
ADD ANGLE   CI  OI1 HI1

{ 
ADD DIHEDRAL  CA  CB  OG  PD
ADD DIHEDRAL  PD  OE  CZ  CH 
ADD DIHEDRAL  OE  CZ  CH  CI
ADD DIHEDRAL  CZ  CH  OH1 HH1
ADD DIHEDRAL  CH  CI  OI1 HI1
ADD DIHEDRAL  CB  OG  PD  OE  {* double dihedral *}
ADD DIHEDRAL  CB  OG  PD  OE  {* =============== *}
ADD DIHEDRAL  OG  PD  OE  CZ  {* double dihedral *}
ADD DIHEDRAL  OG  PD  OE  CZ  {* =============== *}
}

ADD IMPROPER  CH CZ OH1 CI

ADD ACCEPTOR   OD1  PD
ADD ACCEPTOR   OD2  PD
DELETE ACCEPTOR  OG "  " 

END {PGL}

!------------------------------------------------------------------
pRESidue GT6      ! GT6 (Glyceramido acetamido trideoxy-hexose) group patched to SER
                  ! PURE GUESS based on MIP in toph19.his (M Trellet)
                  !
                  ! has to be patched as REFErence=NIL=<selection>
 GROUP            ! 
  MODIFY ATOM  CB  TYPE=CH2E              END!                CA (SER)
  DELETE ATOM  HG                         END!                |
 GROUP                                       !
  MODIFY ATOM  OG  TYPE=OS   CHARge=-0.00 END!                CB (SER)
  ADD 	 ATOM  CC  TYPE=CH1E CHARge= 0.00 END!                |
 GROUP                                       !                OG
  ADD	 ATOM  CHA TYPE=CH1E CHARge= 0.08 END!                |
  ADD 	 ATOM  NHA TYPE=NH1  CHARge= 0.08 END!                CC    H5  O1
  ADD	 ATOM  CD  TYPE=C    CHARge= 0.23 END!               / \    |   "
  ADD	 ATOM  O1  TYPE=O    CHARge=-0.40 END!              O2  CHA-NHA-CD-CE
  ADD 	 ATOM  CE  TYPE=CH3E CHARge= 0.00 END!              |   |   
  ADD    ATOM  H5  TYPE=H    CHARge= 0.01 END!
 GROUP    
  ADD    ATOM  CJ  TYPE=CH1E CHARge= 0.08 END!          CF-CI   CJ-O3-H1     
  ADD    ATOM  O3  TYPE=OH1  CHARge=-0.11 END!               \ /
  ADD    ATOM  H1  TYPE=H    CHARge= 0.03 END!                CK
 GROUP                                       !                NHB-H4          
  ADD    ATOM  O2  TYPE=OS   CHARGE=-0.17 END!                |      
  ADD    ATOM  CI  TYPE=CH1E CHARGE= 0.08 END!                CL=04
  ADD    ATOM  CF  TYPE=CH3E CHARGE= 0.01 END!                |
  ADD 	 ATOM  CC  TYPE=CH1E CHARge= 0.08 END!
 GROUP                                       !                CM-O5-H2
  ADD    ATOM  CK  TYPE=CH1E CHARGE= 0.08 END!                |                 
  ADD    ATOM  NHB TYPE=NH1  CHARGE= 0.08 END!                CN
  ADD    ATOM  H4  TYPE=H    CHARge= 0.01 END!                |
                  			     !	              O6
  ADD    ATOM  CL  TYPE=C    CHARGE= 0.23 END!                |
  ADD    ATOM  O4  TYPE=O    CHARge=-0.40 END!                H3
 GROUP                                       !                
  ADD    ATOM  O5  TYPE=OH1  CHARge=-0.11 END!                
  ADD    ATOM  CM  TYPE=CH1E CHARge= 0.08 END!
  ADD    ATOM  H2  TYPE=H    CHARge= 0.03 END!
 GROUP                
  ADD    ATOM  CN  TYPE=CH2E CHARge= 0.05 END
  ADD    ATOM  O6  TYPE=OH1  CHARge=-0.09 END
  ADD    ATOM  H3  TYPE=H    CHARge= 0.04 END

BOND    OG   CC
BOND    CC   O2
BOND    CC   CHA
BOND    CHA  NHA
BOND    NHA  CD
BOND    NHA  H5
BOND    CD   O1
BOND    CD   CE
BOND    CHA  CJ
BOND    CJ   O3
BOND    O3   H1
BOND    CJ   CK
BOND    O2   CI
BOND    CI   CF
BOND    CI   CK
BOND    CK   NHB
BOND    NHB  H4
BOND    NHB  CL
BOND    CL   O4
BOND    CL   CM
BOND    CM   O5
BOND    O5   H2
BOND    CM   CN
BOND    CN   O6
BOND    O6   H3

ADD ANGLE   CB  OG  CC
ADD ANGLE   OG  CC  O2
ADD ANGLE   OG  CC  CHA
ADD ANGLE   CC  O2  CI
ADD ANGLE   CC  CHA NHA 
ADD ANGLE   CHA NHA CD
ADD ANGLE   CHA NHA H5
ADD ANGLE   H5  NHA CD
ADD ANGLE   NHA CD  O1
ADD ANGLE   NHA CD  CE
ADD ANGLE   O1  CD  CE 
ADD ANGLE   CC  CHA CJ
ADD ANGLE   CHA CJ  O3
ADD ANGLE   O2  CI  CF
ADD ANGLE   O2  CI  CK
ADD ANGLE   CF  CI  CK
ADD ANGLE   CI  CK  NHB
ADD ANGLE   O3  CJ  CK
ADD ANGLE   CJ  CK  NHB
ADD ANGLE   CJ  O3  H1
ADD ANGLE   CF  CI  CK
ADD ANGLE   CK  NHB CL
ADD ANGLE   CK  NHB H4
ADD ANGLE   H4  NHB CL
ADD ANGLE   NHB CL  O4
ADD ANGLE   NHB CL  CM
ADD ANGLE   O4  CL  CM
ADD ANGLE   CL  CM  O5
ADD ANGLE   CL  CM  CN
ADD ANGLE   O5  CM  CN
ADD ANGLE   CM  CN  O6
ADD ANGLE   CM  O5  H2
ADD ANGLE   CN  O6  H3

{ 
ADD DIHEDRAL  CA  CB  OG  CC
ADD DIHEDRAL  CB  OG  CC  O2 
ADD DIHEDRAL  CB  OG  CC  CHA
ADD DIHEDRAL  OG  CC  CHA NHA
ADD DIHEDRAL  OG  CC  CHA CJ
ADD DIHEDRAL  OG  CC  O2  CI  
ADD DIHEDRAL  CC  CHA NHA CD  
ADD DIHEDRAL  CC  CHA NHA H5
ADD DIHEDRAL  CHA NHA CD  O1   
ADD DIHEDRAL  CHA NHA CD  CE
ADD DIHEDRAL  H5  NHA CD  O1  
ADD DIHEDRAL  CC  CHA CJ  O3
ADD DIHEDRAL  CC  CHA CJ  CK
ADD DIHEDRAL  CC  O2  CI  CF
ADD DIHEDRAL  CC  O2  CI  CK
ADD DIHEDRAL  CHA CJ  CK  NHB
ADD DIHEDRAL  O3  CJ  CK  NHB
ADD DIHEDRAL  CF  CI  CK  NHB
ADD DIHEDRAL  O2  CC  CHA NHA
ADD DIHEDRAL  O2  CC  CHA CJ
ADD DIHEDRAL  CI  O2  CC  NHA
ADD DIHEDRAL  CI  CK  NHB CL
ADD DIHEDRAL  CJ  CK  NHB CL
ADD DIHEDRAL  CK  NHB CL  O4
ADD DIHEDRAL  CK  NHB CL  CM
ADD DIHEDRAL  NHB CL  CM  O5
ADD DIHEDRAL  NHB CL  CM  CN
ADD DIHEDRAL  CM  CL  CN  O6
ADD DIHEDRAL  CHA CJ  O3  H1
ADD DIHEDRAL  CK  CJ  O3  H1
ADD DIHEDRAL  CJ  CK  NHB H4
ADD DIHEDRAL  CI  CK  NHB H4
ADD DIHEDRAL  O4  CL  NHB H4
ADD DIHEDRAL  CM  CL  NHB H4
ADD DIHEDRAL  CL  CM  O5  H2
ADD DIHEDRAL  CN  CM  O5  H2
ADD DIHEDRAL  CM  CN  O6  H3
ADD DIHEDRAL  CJ  CHA NHA H5
}

ADD IMPROPER  CC  O2  CHA OG  
ADD IMPROPER  CHA CJ  NHA CC
ADD IMPROPER  CJ  CK  O3  CHA
ADD IMPROPER  CI  CK  O2  CF
ADD IMPROPER  CK  NHB CJ  CI
ADD IMPROPER  CM  CN  O5  CL
!ADD IMPROPER  NHA CD  H5  NHA
!ADD IMPROPER  NHB CL  H4  CK

ADD ACCEPTOR   O6   CN
ADD ACCEPTOR   O5   CM
ADD ACCEPTOR   O3   CJ
DELETE ACCEPTOR  OG "  " 

END {GT6}

!------------------------------------------------------------------
PRESidue OPE      ! OPE (Colamine Phosphoric Acid) group patched to SER
                  ! PURE GUESS based on MIP in toph19.his (M Trellet)
                  !
                  ! has to be patched as REFErence=NIL=<selection>
 GROUP            ! 
  MODIFY ATOM  CB  TYPE=CH2E              END!                CA (SER)
  DELETE ATOM  HG                         END!                |
 GROUP                                       !                CB (SER)
  MODIFY ATOM  OG  TYPE=OS   CHARge=-0.40 END!                |
  ADD    ATOM  PD  TYPE=P    CHARge= 1.15 END!                OG
  ADD    ATOM  OD1 TYPE=O2   CHARge=-0.29 END!                |      
  ADD    ATOM  OD2 TYPE=OH1  CHARge=-0.39 END!         OD1 -- PD - OD2-HG1
  ADD    ATOM  OE  TYPE=OS   CHARge=-0.07 END!                |
  ADD    ATOM  HG1 TYPE=H    CHARge= 0.00 END!
 GROUP                                       !                OE
  ADD    ATOM  CZ  TYPE=CH2E CHARge= 0.0  END!                | 
  ADD    ATOM  CI  TYPE=CH2E CHARge= 0.0  END!                CZ
 GROUP                                       !                |      
  ADD    ATOM  NH1 TYPE=NH2  CHARGE= 0.00 END!                CI
  ADD    ATOM  HH1 TYPE=H    CHARGE= 0.00 END!                |
  ADD    ATOM  HI1 TYPE=H    CHARGE= 0.00 END!            HH1-NH1-HI1
 
BOND    OG   PD
BOND    PD   OD2
BOND    OD2  HG1
BOND    PD   OD1
BOND    PD   OE
BOND    OE   CZ
BOND    CZ   CI
BOND    CI   NH1
BOND    NH1  HH1
BOND    NH1  HI1

ADD ANGLE   CB  OG  PD
ADD ANGLE   OG  PD  OD2
ADD ANGLE   OG  PD  OD1
ADD ANGLE   OG  PD  OE
ADD ANGLE   OD1 PD  OE 
ADD ANGLE   OD2 PD  OD1
ADD ANGLE   HG1 OD2 PD
ADD ANGLE   OD2 PD  OE
ADD ANGLE   PD  OE  CZ
ADD ANGLE   OE  CZ  CI 
ADD ANGLE   CZ  CI  NH1
ADD ANGLE   CI  NH1 HH1
ADD ANGLE   CI  NH1 HI1
ADD ANGLE   HH1 NH1 HI1

{ 
ADD DIHEDRAL  CA  CB  OG  PD
ADD DIHEDRAL  PD  OE  CZ  CH 
ADD DIHEDRAL  OE  CZ  CH  CI
ADD DIHEDRAL  CZ  CH  OH1 HH1
ADD DIHEDRAL  CH  CI  OI1 HI1
ADD DIHEDRAL  CB  OG  PD  OE  {* double dihedral *}
ADD DIHEDRAL  CB  OG  PD  OE  {* =============== *}
ADD DIHEDRAL  OG  PD  OE  CZ  {* double dihedral *}
ADD DIHEDRAL  OG  PD  OE  CZ  {* =============== *}
}

!ADD ACCEPTOR   OD1  PD
ADD ACCEPTOR   OD2  PD
DELETE ACCEPTOR  OG "  " 

END {PGL}

!------------------------------------------------------------------
pRESidue DT6      ! DT6 (Diacetamido-2,4,6-trideoxyhexose) group patched to SER
                  ! PURE GUESS based on MIP in toph19.his (M Trellet)
                  !
                  ! has to be patched as REFErence=NIL=<selection>
 GROUP            ! 
  MODIFY ATOM  CB  TYPE=CH2E              END!                CA (SER)
  DELETE ATOM  HG                         END!                |
 GROUP                                       !
  MODIFY ATOM  OG  TYPE=OS   CHARge=-0.00 END!                CB (SER)
  ADD 	 ATOM  CC  TYPE=CH1E CHARge= 0.00 END!                |
 GROUP                                       !                OG
  ADD	 ATOM  CHA TYPE=CH1E CHARge= 0.08 END!                |
  ADD 	 ATOM  NHA TYPE=NH1  CHARge= 0.08 END!                CC    H5  O1
  ADD	 ATOM  CD  TYPE=C    CHARge= 0.23 END!               / \    |   "
  ADD	 ATOM  O1  TYPE=O    CHARge=-0.40 END!              O2  CHA-NHA-CD-CE
  ADD 	 ATOM  CE  TYPE=CH3E CHARge= 0.00 END!              |   |   
  ADD    ATOM  H5  TYPE=H    CHARge= 0.01 END!
 GROUP    
  ADD    ATOM  CJ  TYPE=CH1E CHARge= 0.08 END!          CF-CI   CJ-O3-H1     
  ADD    ATOM  O3  TYPE=OH1  CHARge=-0.11 END!               \ /
  ADD    ATOM  H1  TYPE=H    CHARge= 0.03 END!                CK
 GROUP                                       !                NHB-H4          
  ADD    ATOM  O2  TYPE=OS   CHARGE=-0.17 END!                |      
  ADD    ATOM  CI  TYPE=CH1E CHARGE= 0.08 END!                CL=04
  ADD    ATOM  CF  TYPE=CH3E CHARGE= 0.01 END!                |
  ADD 	 ATOM  CC  TYPE=CH1E CHARge= 0.08 END!                CM
 GROUP                                       !                
  ADD    ATOM  CK  TYPE=CH1E CHARGE= 0.08 END!                                 
  ADD    ATOM  NHB TYPE=NH1  CHARGE= 0.08 END!                
  ADD    ATOM  H4  TYPE=H    CHARge= 0.01 END!                
                  			     !	              
  ADD    ATOM  CL  TYPE=C    CHARGE= 0.23 END!                
  ADD    ATOM  O4  TYPE=O    CHARge=-0.40 END!                
 GROUP                                       !                
  ADD    ATOM  CM  TYPE=CH3E CHARge= 0.00 END!
  
BOND    OG   CC
BOND    CC   O2
BOND    CC   CHA
BOND    CHA  NHA
BOND    NHA  CD
BOND    NHA  H5
BOND    CD   O1
BOND    CD   CE
BOND    CHA  CJ
BOND    CJ   O3
BOND    O3   H1
BOND    CJ   CK
BOND    O2   CI
BOND    CI   CF
BOND    CI   CK
BOND    CK   NHB
BOND    NHB  H4
BOND    NHB  CL
BOND    CL   O4
BOND    CL   CM

ADD ANGLE   CB  OG  CC
ADD ANGLE   OG  CC  O2
ADD ANGLE   OG  CC  CHA
ADD ANGLE   CC  O2  CI
ADD ANGLE   CC  CHA NHA 
ADD ANGLE   CHA NHA CD
ADD ANGLE   CHA NHA H5
ADD ANGLE   H5  NHA CD
ADD ANGLE   NHA CD  O1
ADD ANGLE   NHA CD  CE
ADD ANGLE   O1  CD  CE 
ADD ANGLE   CC  CHA CJ
ADD ANGLE   CHA CJ  O3
ADD ANGLE   O2  CI  CF
ADD ANGLE   O2  CI  CK
ADD ANGLE   CF  CI  CK
ADD ANGLE   CI  CK  NHB
ADD ANGLE   O3  CJ  CK
ADD ANGLE   CJ  CK  NHB
ADD ANGLE   CJ  O3  H1
ADD ANGLE   CF  CI  CK
ADD ANGLE   CK  NHB CL
ADD ANGLE   CK  NHB H4
ADD ANGLE   H4  NHB CL
ADD ANGLE   NHB CL  O4
ADD ANGLE   NHB CL  CM
ADD ANGLE   O4  CL  CM

{ 
ADD DIHEDRAL  CA  CB  OG  CC
ADD DIHEDRAL  CB  OG  CC  O2 
ADD DIHEDRAL  CB  OG  CC  CHA
ADD DIHEDRAL  OG  CC  CHA NHA
ADD DIHEDRAL  OG  CC  CHA CJ
ADD DIHEDRAL  OG  CC  O2  CI  
ADD DIHEDRAL  CC  CHA NHA CD  
ADD DIHEDRAL  CC  CHA NHA H5
ADD DIHEDRAL  CHA NHA CD  O1   
ADD DIHEDRAL  CHA NHA CD  CE
ADD DIHEDRAL  H5  NHA CD  O1  
ADD DIHEDRAL  CC  CHA CJ  O3
ADD DIHEDRAL  CC  CHA CJ  CK
ADD DIHEDRAL  CC  O2  CI  CF
ADD DIHEDRAL  CC  O2  CI  CK
ADD DIHEDRAL  CHA CJ  CK  NHB
ADD DIHEDRAL  O3  CJ  CK  NHB
ADD DIHEDRAL  CF  CI  CK  NHB
ADD DIHEDRAL  O2  CC  CHA NHA
ADD DIHEDRAL  O2  CC  CHA CJ
ADD DIHEDRAL  CI  O2  CC  NHA
ADD DIHEDRAL  CI  CK  NHB CL
ADD DIHEDRAL  CJ  CK  NHB CL
ADD DIHEDRAL  CK  NHB CL  O4
ADD DIHEDRAL  CK  NHB CL  CM
ADD DIHEDRAL  NHB CL  CM  O5
ADD DIHEDRAL  NHB CL  CM  CN
ADD DIHEDRAL  CM  CL  CN  O6
ADD DIHEDRAL  CHA CJ  O3  H1
ADD DIHEDRAL  CK  CJ  O3  H1
ADD DIHEDRAL  CJ  CK  NHB H4
ADD DIHEDRAL  CI  CK  NHB H4
ADD DIHEDRAL  O4  CL  NHB H4
ADD DIHEDRAL  CM  CL  NHB H4
ADD DIHEDRAL  CL  CM  O5  H2
ADD DIHEDRAL  CN  CM  O5  H2
ADD DIHEDRAL  CM  CN  O6  H3
ADD DIHEDRAL  CJ  CHA NHA H5
}

ADD IMPROPER  CC  O2  CHA OG  
ADD IMPROPER  CHA CJ  NHA CC
ADD IMPROPER  CJ  CK  O3  CHA
ADD IMPROPER  CI  CK  O2  CF
ADD IMPROPER  CK  NHB CJ  CI
!ADD IMPROPER  NHA CD  H5  NHA
!ADD IMPROPER  NHB CL  H4  CK

ADD ACCEPTOR   O3   CJ
DELETE ACCEPTOR  OG "  " 

END {DT6}


RESIdue CAL           ! CA ION
  ATOM CAL  TYPE= CAL {right now we don't have a CA}  CHARge= 2.00 END
END {CAL}

set echo=true end
